## Member Custom Property

On top of intrinsic member properties, user defined properties can be attached to members.




### Description

User-defined member properties are defined within hierarchy's levels. See this [page](../user_guide/schemas_cubes/dimensions.md) for more details about how to create dimensions.

Once defined, the syntax to retrieve user-defined member properties is similar to that used to retrieve intrinsic member properties (e.g., Properties function).

The following icCube features are supported via custom member properties :
 <ul>
        <li> [@UO](../user_guide/schemas_cubes/facts_aggregation.md) : defines the member's unary operator for custom aggregation
        <li> [@MC_](../user_guide/schemas_cubes/localization.md) : defines the localized member's caption
        <li> @Ic3Color : defines the color of a member (used by the reporting)
        <li> @Ic3Lat : defines the latitude of a member (used by the reporting)
        <li> @Ic3Long : defines the longitude of a member (used by the reporting)
        <li> @Ic3iso2 : defines the country codes [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)) of a member (used by the reporting)
 </ul>



                                                                      

### See Also


[Dimension Properties](Dimension%20Properties.md)

[Member Attributes](Member%20Attributes.md)

[Properties](Properties.md)

[GetProperty](GetProperty.md)

[GetPropertyUniqueValues](GetPropertyUniqueValues.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
